package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledInstance(
    availabilityZone: Option[String] = None,
    createDate: Option[DateTime] = None,
    hourlyPrice: Option[String] = None,
    instanceCount: Option[Integer] = None,
    instanceType: Option[String] = None,
    networkPlatform: Option[String] = None,
    nextSlotStartTime: Option[DateTime] = None,
    platform: Option[String] = None,
    previousSlotEndTime: Option[DateTime] = None,
    recurrence: Option[zio.aws.ec2.model.ScheduledInstanceRecurrence] = None,
    scheduledInstanceId: Option[String] = None,
    slotDurationInHours: Option[Integer] = None,
    termEndDate: Option[DateTime] = None,
    termStartDate: Option[DateTime] = None,
    totalScheduledInstanceHours: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstance = {
    import ScheduledInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstance
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(networkPlatform.map(value => value: java.lang.String))(
        _.networkPlatform
      )
      .optionallyWith(
        nextSlotStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.nextSlotStartTime)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(
        previousSlotEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.previousSlotEndTime)
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(
        scheduledInstanceId.map(value => value: java.lang.String)
      )(_.scheduledInstanceId)
      .optionallyWith(
        slotDurationInHours.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.slotDurationInHours)
      .optionallyWith(
        termEndDate.map(value => DateTime.unwrap(value): Instant)
      )(_.termEndDate)
      .optionallyWith(
        termStartDate.map(value => DateTime.unwrap(value): Instant)
      )(_.termStartDate)
      .optionallyWith(
        totalScheduledInstanceHours.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalScheduledInstanceHours)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstance.ReadOnly =
    zio.aws.ec2.model.ScheduledInstance.wrap(buildAwsValue())
}
object ScheduledInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstance =
      zio.aws.ec2.model.ScheduledInstance(
        availabilityZone.map(value => value),
        createDate.map(value => value),
        hourlyPrice.map(value => value),
        instanceCount.map(value => value),
        instanceType.map(value => value),
        networkPlatform.map(value => value),
        nextSlotStartTime.map(value => value),
        platform.map(value => value),
        previousSlotEndTime.map(value => value),
        recurrence.map(value => value.asEditable),
        scheduledInstanceId.map(value => value),
        slotDurationInHours.map(value => value),
        termEndDate.map(value => value),
        termStartDate.map(value => value),
        totalScheduledInstanceHours.map(value => value)
      )
    def availabilityZone: Option[String]
    def createDate: Option[DateTime]
    def hourlyPrice: Option[String]
    def instanceCount: Option[Integer]
    def instanceType: Option[String]
    def networkPlatform: Option[String]
    def nextSlotStartTime: Option[DateTime]
    def platform: Option[String]
    def previousSlotEndTime: Option[DateTime]
    def recurrence
        : Option[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly]
    def scheduledInstanceId: Option[String]
    def slotDurationInHours: Option[Integer]
    def termEndDate: Option[DateTime]
    def termStartDate: Option[DateTime]
    def totalScheduledInstanceHours: Option[Integer]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getNetworkPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkPlatform", networkPlatform)
    def getNextSlotStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("nextSlotStartTime", nextSlotStartTime)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getPreviousSlotEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("previousSlotEndTime", previousSlotEndTime)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getScheduledInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledInstanceId", scheduledInstanceId)
    def getSlotDurationInHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("slotDurationInHours", slotDurationInHours)
    def getTermEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("termEndDate", termEndDate)
    def getTermStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("termStartDate", termStartDate)
    def getTotalScheduledInstanceHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalScheduledInstanceHours",
        totalScheduledInstanceHours
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ) extends zio.aws.ec2.model.ScheduledInstance.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val createDate: Option[DateTime] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hourlyPrice: Option[String] =
      scala.Option(impl.hourlyPrice()).map(value => value: String)
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val networkPlatform: Option[String] =
      scala.Option(impl.networkPlatform()).map(value => value: String)
    override val nextSlotStartTime: Option[DateTime] = scala
      .Option(impl.nextSlotStartTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val previousSlotEndTime: Option[DateTime] = scala
      .Option(impl.previousSlotEndTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val recurrence
        : Option[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly] = scala
      .Option(impl.recurrence())
      .map(value => zio.aws.ec2.model.ScheduledInstanceRecurrence.wrap(value))
    override val scheduledInstanceId: Option[String] =
      scala.Option(impl.scheduledInstanceId()).map(value => value: String)
    override val slotDurationInHours: Option[Integer] = scala
      .Option(impl.slotDurationInHours())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val termEndDate: Option[DateTime] = scala
      .Option(impl.termEndDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val termStartDate: Option[DateTime] = scala
      .Option(impl.termStartDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val totalScheduledInstanceHours: Option[Integer] = scala
      .Option(impl.totalScheduledInstanceHours())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ): zio.aws.ec2.model.ScheduledInstance.ReadOnly = new Wrapper(impl)
}
