package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunInstancesResponse(
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    instances: Option[Iterable[zio.aws.ec2.model.Instance]] = None,
    ownerId: Option[String] = None,
    requesterId: Option[String] = None,
    reservationId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunInstancesResponse = {
    import RunInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunInstancesResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(requesterId.map(value => value: java.lang.String))(
        _.requesterId
      )
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunInstancesResponse.ReadOnly =
    zio.aws.ec2.model.RunInstancesResponse.wrap(buildAwsValue())
}
object RunInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunInstancesResponse =
      zio.aws.ec2.model.RunInstancesResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        requesterId.map(value => value),
        reservationId.map(value => value)
      )
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def instances: Option[List[zio.aws.ec2.model.Instance.ReadOnly]]
    def ownerId: Option[String]
    def requesterId: Option[String]
    def reservationId: Option[String]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getRequesterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterId", requesterId)
    def getReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationId", reservationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesResponse
  ) extends zio.aws.ec2.model.RunInstancesResponse.ReadOnly {
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val instances: Option[List[zio.aws.ec2.model.Instance.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Instance.wrap(item)
          }.toList
        )
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val requesterId: Option[String] =
      scala.Option(impl.requesterId()).map(value => value: String)
    override val reservationId: Option[String] =
      scala.Option(impl.reservationId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesResponse
  ): zio.aws.ec2.model.RunInstancesResponse.ReadOnly = new Wrapper(impl)
}
