package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RouteTable(
    associations: Option[Iterable[zio.aws.ec2.model.RouteTableAssociation]] =
      None,
    propagatingVgws: Option[Iterable[zio.aws.ec2.model.PropagatingVgw]] = None,
    routeTableId: Option[String] = None,
    routes: Option[Iterable[zio.aws.ec2.model.Route]] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vpcId: Option[String] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.RouteTable = {
    import RouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RouteTable
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        propagatingVgws.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propagatingVgws)
      .optionallyWith(routeTableId.map(value => value: java.lang.String))(
        _.routeTableId
      )
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RouteTable.ReadOnly =
    zio.aws.ec2.model.RouteTable.wrap(buildAwsValue())
}
object RouteTable {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.RouteTable] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RouteTable = zio.aws.ec2.model.RouteTable(
      associations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      propagatingVgws.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      routeTableId.map(value => value),
      routes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcId.map(value => value),
      ownerId.map(value => value)
    )
    def associations
        : Option[List[zio.aws.ec2.model.RouteTableAssociation.ReadOnly]]
    def propagatingVgws: Option[List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]]
    def routeTableId: Option[String]
    def routes: Option[List[zio.aws.ec2.model.Route.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Option[String]
    def ownerId: Option[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RouteTableAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getPropagatingVgws
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]] =
      AwsError.unwrapOptionField("propagatingVgws", propagatingVgws)
    def getRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getRoutes: ZIO[Any, AwsError, List[zio.aws.ec2.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("routes", routes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RouteTable
  ) extends zio.aws.ec2.model.RouteTable.ReadOnly {
    override val associations
        : Option[List[zio.aws.ec2.model.RouteTableAssociation.ReadOnly]] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RouteTableAssociation.wrap(item)
        }.toList
      )
    override val propagatingVgws
        : Option[List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]] = scala
      .Option(impl.propagatingVgws())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PropagatingVgw.wrap(item)
        }.toList
      )
    override val routeTableId: Option[String] =
      scala.Option(impl.routeTableId()).map(value => value: String)
    override val routes: Option[List[zio.aws.ec2.model.Route.ReadOnly]] = scala
      .Option(impl.routes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Route.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RouteTable
  ): zio.aws.ec2.model.RouteTable.ReadOnly = new Wrapper(impl)
}
