package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReportInstanceReasonCodes {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes
}
object ReportInstanceReasonCodes {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes
  ): zio.aws.ec2.model.ReportInstanceReasonCodes = value match {
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.INSTANCE_STUCK_IN_STATE =>
      val r = `instance-stuck-in-state`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.UNRESPONSIVE =>
      val r = unresponsive
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.NOT_ACCEPTING_CREDENTIALS =>
      val r = `not-accepting-credentials`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PASSWORD_NOT_AVAILABLE =>
      val r = `password-not-available`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_NETWORK =>
      val r = `performance-network`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_INSTANCE_STORE =>
      val r = `performance-instance-store`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_EBS_VOLUME =>
      val r = `performance-ebs-volume`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_OTHER =>
      val r = `performance-other`
      r
    case software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.OTHER =>
      val r = other
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.UNKNOWN_TO_SDK_VERSION
  }
  case object `instance-stuck-in-state`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.INSTANCE_STUCK_IN_STATE
  }
  case object unresponsive extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.UNRESPONSIVE
  }
  case object `not-accepting-credentials`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.NOT_ACCEPTING_CREDENTIALS
  }
  case object `password-not-available`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PASSWORD_NOT_AVAILABLE
  }
  case object `performance-network`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_NETWORK
  }
  case object `performance-instance-store`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_INSTANCE_STORE
  }
  case object `performance-ebs-volume`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_EBS_VOLUME
  }
  case object `performance-other`
      extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.PERFORMANCE_OTHER
  }
  case object other extends zio.aws.ec2.model.ReportInstanceReasonCodes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes =
      software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes.OTHER
  }
}
