package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReleaseIpamPoolAllocationResponse(
    success: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse = {
    import ReleaseIpamPoolAllocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse
      .builder()
      .optionallyWith(success.map(value => value: java.lang.Boolean))(_.success)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly =
    zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.wrap(buildAwsValue())
}
object ReleaseIpamPoolAllocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse =
      zio.aws.ec2.model
        .ReleaseIpamPoolAllocationResponse(success.map(value => value))
    def success: Option[Boolean]
    def getSuccess: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("success", success)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse
  ) extends zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly {
    override val success: Option[Boolean] =
      scala.Option(impl.success()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse
  ): zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly = new Wrapper(
    impl
  )
}
