package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseReservedInstancesOfferingResponse(
    reservedInstancesId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse = {
    import PurchaseReservedInstancesOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse
      .builder()
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly =
    zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedInstancesOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse =
      zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse(
        reservedInstancesId.map(value => value)
      )
    def reservedInstancesId: Option[String]
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse
  ) extends zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly {
    override val reservedInstancesId: Option[String] =
      scala.Option(impl.reservedInstancesId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse
  ): zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
