package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PeeringTgwInfo(
    transitGatewayId: Option[String] = None,
    ownerId: Option[String] = None,
    region: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PeeringTgwInfo = {
    import PeeringTgwInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
      .builder()
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PeeringTgwInfo.ReadOnly =
    zio.aws.ec2.model.PeeringTgwInfo.wrap(buildAwsValue())
}
object PeeringTgwInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PeeringTgwInfo =
      zio.aws.ec2.model.PeeringTgwInfo(
        transitGatewayId.map(value => value),
        ownerId.map(value => value),
        region.map(value => value)
      )
    def transitGatewayId: Option[String]
    def ownerId: Option[String]
    def region: Option[String]
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ) extends zio.aws.ec2.model.PeeringTgwInfo.ReadOnly {
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ): zio.aws.ec2.model.PeeringTgwInfo.ReadOnly = new Wrapper(impl)
}
