package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NatGateway(
    createTime: Option[DateTime] = None,
    deleteTime: Option[DateTime] = None,
    failureCode: Option[String] = None,
    failureMessage: Option[String] = None,
    natGatewayAddresses: Option[Iterable[zio.aws.ec2.model.NatGatewayAddress]] =
      None,
    natGatewayId: Option[String] = None,
    provisionedBandwidth: Option[zio.aws.ec2.model.ProvisionedBandwidth] = None,
    state: Option[zio.aws.ec2.model.NatGatewayState] = None,
    subnetId: Option[String] = None,
    vpcId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    connectivityType: Option[zio.aws.ec2.model.ConnectivityType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NatGateway = {
    import NatGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NatGateway
      .builder()
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(deleteTime.map(value => DateTime.unwrap(value): Instant))(
        _.deleteTime
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        natGatewayAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.natGatewayAddresses)
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(provisionedBandwidth.map(value => value.buildAwsValue()))(
        _.provisionedBandwidth
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(connectivityType.map(value => value.unwrap))(
        _.connectivityType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NatGateway.ReadOnly =
    zio.aws.ec2.model.NatGateway.wrap(buildAwsValue())
}
object NatGateway {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NatGateway] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NatGateway = zio.aws.ec2.model.NatGateway(
      createTime.map(value => value),
      deleteTime.map(value => value),
      failureCode.map(value => value),
      failureMessage.map(value => value),
      natGatewayAddresses.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      natGatewayId.map(value => value),
      provisionedBandwidth.map(value => value.asEditable),
      state.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      connectivityType.map(value => value)
    )
    def createTime: Option[DateTime]
    def deleteTime: Option[DateTime]
    def failureCode: Option[String]
    def failureMessage: Option[String]
    def natGatewayAddresses
        : Option[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]]
    def natGatewayId: Option[String]
    def provisionedBandwidth
        : Option[zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly]
    def state: Option[zio.aws.ec2.model.NatGatewayState]
    def subnetId: Option[String]
    def vpcId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def connectivityType: Option[zio.aws.ec2.model.ConnectivityType]
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getDeleteTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("deleteTime", deleteTime)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getNatGatewayAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NatGatewayAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("natGatewayAddresses", natGatewayAddresses)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getProvisionedBandwidth
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly] =
      AwsError.unwrapOptionField("provisionedBandwidth", provisionedBandwidth)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.NatGatewayState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConnectivityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectivityType] =
      AwsError.unwrapOptionField("connectivityType", connectivityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NatGateway
  ) extends zio.aws.ec2.model.NatGateway.ReadOnly {
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val deleteTime: Option[DateTime] = scala
      .Option(impl.deleteTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val failureCode: Option[String] =
      scala.Option(impl.failureCode()).map(value => value: String)
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val natGatewayAddresses
        : Option[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]] = scala
      .Option(impl.natGatewayAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NatGatewayAddress.wrap(item)
        }.toList
      )
    override val natGatewayId: Option[String] =
      scala.Option(impl.natGatewayId()).map(value => value: String)
    override val provisionedBandwidth
        : Option[zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly] = scala
      .Option(impl.provisionedBandwidth())
      .map(value => zio.aws.ec2.model.ProvisionedBandwidth.wrap(value))
    override val state: Option[zio.aws.ec2.model.NatGatewayState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.NatGatewayState.wrap(value))
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val connectivityType: Option[zio.aws.ec2.model.ConnectivityType] =
      scala
        .Option(impl.connectivityType())
        .map(value => zio.aws.ec2.model.ConnectivityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NatGateway
  ): zio.aws.ec2.model.NatGateway.ReadOnly = new Wrapper(impl)
}
