package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceCapacityReservationAttributesResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse = {
    import ModifyInstanceCapacityReservationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse
      .wrap(buildAwsValue())
}
object ModifyInstanceCapacityReservationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse =
      zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse(
        returnValue.map(value => value)
      )
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse
  ) extends zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse
  ): zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
