package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyDefaultCreditSpecificationRequest(
    instanceFamily: zio.aws.ec2.model.UnlimitedSupportedInstanceFamily,
    cpuCredits: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest = {
    import ModifyDefaultCreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest
      .builder()
      .instanceFamily(instanceFamily.unwrap)
      .cpuCredits(cpuCredits: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest
      .wrap(buildAwsValue())
}
object ModifyDefaultCreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest =
      zio.aws.ec2.model
        .ModifyDefaultCreditSpecificationRequest(instanceFamily, cpuCredits)
    def instanceFamily: zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
    def cpuCredits: String
    def getInstanceFamily: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
    ] = ZIO.succeed(instanceFamily)
    def getCpuCredits: ZIO[Any, Nothing, String] = ZIO.succeed(cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest
  ) extends zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest.ReadOnly {
    override val instanceFamily
        : zio.aws.ec2.model.UnlimitedSupportedInstanceFamily =
      zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
        .wrap(impl.instanceFamily())
    override val cpuCredits: String = impl.cpuCredits(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest
  ): zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
