package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyAvailabilityZoneGroupResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse = {
    import ModifyAvailabilityZoneGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly =
    zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.wrap(buildAwsValue())
}
object ModifyAvailabilityZoneGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse =
      zio.aws.ec2.model
        .ModifyAvailabilityZoneGroupResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse
  ) extends zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse
  ): zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly =
    new Wrapper(impl)
}
