package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceMetadataOptionsRequest(
    httpTokens: Option[zio.aws.ec2.model.LaunchTemplateHttpTokensState] = None,
    httpPutResponseHopLimit: Option[Integer] = None,
    httpEndpoint: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState
    ] = None,
    httpProtocolIpv6: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6
    ] = None,
    instanceMetadataTags: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest = {
    import LaunchTemplateInstanceMetadataOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
      .builder()
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .optionallyWith(instanceMetadataTags.map(value => value.unwrap))(
        _.instanceMetadataTags
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateInstanceMetadataOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest =
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest(
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value),
        instanceMetadataTags.map(value => value)
      )
    def httpTokens: Option[zio.aws.ec2.model.LaunchTemplateHttpTokensState]
    def httpPutResponseHopLimit: Option[Integer]
    def httpEndpoint
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState]
    def httpProtocolIpv6
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6]
    def instanceMetadataTags
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState]
    def getHttpTokens
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplateHttpTokensState] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState
    ] = AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6
    ] = AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
    def getInstanceMetadataTags: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState
    ] = AwsError.unwrapOptionField("instanceMetadataTags", instanceMetadataTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly {
    override val httpTokens
        : Option[zio.aws.ec2.model.LaunchTemplateHttpTokensState] = scala
      .Option(impl.httpTokens())
      .map(value => zio.aws.ec2.model.LaunchTemplateHttpTokensState.wrap(value))
    override val httpPutResponseHopLimit: Option[Integer] = scala
      .Option(impl.httpPutResponseHopLimit())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val httpEndpoint: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState
    ] = scala
      .Option(impl.httpEndpoint())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState
          .wrap(value)
      )
    override val httpProtocolIpv6
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6] =
      scala
        .Option(impl.httpProtocolIpv6())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6
            .wrap(value)
        )
    override val instanceMetadataTags
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState] =
      scala
        .Option(impl.instanceMetadataTags())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
  ): zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
