package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateEnclaveOptions(enabled: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions = {
    import LaunchTemplateEnclaveOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateEnclaveOptions.wrap(buildAwsValue())
}
object LaunchTemplateEnclaveOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateEnclaveOptions =
      zio.aws.ec2.model
        .LaunchTemplateEnclaveOptions(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions
  ) extends zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions
  ): zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly = new Wrapper(impl)
}
