package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceRequirementsWithMetadataRequest(
    architectureTypes: Option[Iterable[zio.aws.ec2.model.ArchitectureType]] =
      None,
    virtualizationTypes: Option[
      Iterable[zio.aws.ec2.model.VirtualizationType]
    ] = None,
    instanceRequirements: Option[
      zio.aws.ec2.model.InstanceRequirementsRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest = {
    import InstanceRequirementsWithMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest
      .builder()
      .optionallyWith(
        architectureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architectureTypesWithStrings)
      .optionallyWith(
        virtualizationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.virtualizationTypesWithStrings)
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly =
    zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest
      .wrap(buildAwsValue())
}
object InstanceRequirementsWithMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest =
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest(
        architectureTypes.map(value => value),
        virtualizationTypes.map(value => value),
        instanceRequirements.map(value => value.asEditable)
      )
    def architectureTypes: Option[List[zio.aws.ec2.model.ArchitectureType]]
    def virtualizationTypes: Option[List[zio.aws.ec2.model.VirtualizationType]]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly]
    def getArchitectureTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ArchitectureType]] =
      AwsError.unwrapOptionField("architectureTypes", architectureTypes)
    def getVirtualizationTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VirtualizationType]] =
      AwsError.unwrapOptionField("virtualizationTypes", virtualizationTypes)
    def getInstanceRequirements: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest
  ) extends zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly {
    override val architectureTypes
        : Option[List[zio.aws.ec2.model.ArchitectureType]] = scala
      .Option(impl.architectureTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ArchitectureType.wrap(item)
        }.toList
      )
    override val virtualizationTypes
        : Option[List[zio.aws.ec2.model.VirtualizationType]] = scala
      .Option(impl.virtualizationTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VirtualizationType.wrap(item)
        }.toList
      )
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirementsRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest
  ): zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
