package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportVolumeRequest(
    availabilityZone: String,
    description: Option[String] = None,
    image: zio.aws.ec2.model.DiskImageDetail,
    volume: zio.aws.ec2.model.VolumeDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportVolumeRequest = {
    import ImportVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportVolumeRequest
      .builder()
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .image(image.buildAwsValue())
      .volume(volume.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportVolumeRequest.ReadOnly =
    zio.aws.ec2.model.ImportVolumeRequest.wrap(buildAwsValue())
}
object ImportVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportVolumeRequest =
      zio.aws.ec2.model.ImportVolumeRequest(
        availabilityZone,
        description.map(value => value),
        image.asEditable,
        volume.asEditable
      )
    def availabilityZone: String
    def description: Option[String]
    def image: zio.aws.ec2.model.DiskImageDetail.ReadOnly
    def volume: zio.aws.ec2.model.VolumeDetail.ReadOnly
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, Nothing, zio.aws.ec2.model.DiskImageDetail.ReadOnly] =
      ZIO.succeed(image)
    def getVolume: ZIO[Any, Nothing, zio.aws.ec2.model.VolumeDetail.ReadOnly] =
      ZIO.succeed(volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeRequest
  ) extends zio.aws.ec2.model.ImportVolumeRequest.ReadOnly {
    override val availabilityZone: String = impl.availabilityZone(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val image: zio.aws.ec2.model.DiskImageDetail.ReadOnly =
      zio.aws.ec2.model.DiskImageDetail.wrap(impl.image())
    override val volume: zio.aws.ec2.model.VolumeDetail.ReadOnly =
      zio.aws.ec2.model.VolumeDetail.wrap(impl.volume())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeRequest
  ): zio.aws.ec2.model.ImportVolumeRequest.ReadOnly = new Wrapper(impl)
}
