package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ImageRecycleBinInfo(
    imageId: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    recycleBinEnterTime: Option[MillisecondDateTime] = None,
    recycleBinExitTime: Option[MillisecondDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo = {
    import ImageRecycleBinInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        recycleBinEnterTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinEnterTime)
      .optionallyWith(
        recycleBinExitTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinExitTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly =
    zio.aws.ec2.model.ImageRecycleBinInfo.wrap(buildAwsValue())
}
object ImageRecycleBinInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImageRecycleBinInfo =
      zio.aws.ec2.model.ImageRecycleBinInfo(
        imageId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        recycleBinEnterTime.map(value => value),
        recycleBinExitTime.map(value => value)
      )
    def imageId: Option[String]
    def name: Option[String]
    def description: Option[String]
    def recycleBinEnterTime: Option[MillisecondDateTime]
    def recycleBinExitTime: Option[MillisecondDateTime]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRecycleBinEnterTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinEnterTime", recycleBinEnterTime)
    def getRecycleBinExitTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinExitTime", recycleBinExitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ) extends zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly {
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val recycleBinEnterTime: Option[MillisecondDateTime] = scala
      .Option(impl.recycleBinEnterTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val recycleBinExitTime: Option[MillisecondDateTime] = scala
      .Option(impl.recycleBinExitTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ): zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly = new Wrapper(impl)
}
