package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Host(
    autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = None,
    availabilityZone: Option[String] = None,
    availableCapacity: Option[zio.aws.ec2.model.AvailableCapacity] = None,
    clientToken: Option[String] = None,
    hostId: Option[String] = None,
    hostProperties: Option[zio.aws.ec2.model.HostProperties] = None,
    hostReservationId: Option[String] = None,
    instances: Option[Iterable[zio.aws.ec2.model.HostInstance]] = None,
    state: Option[zio.aws.ec2.model.AllocationState] = None,
    allocationTime: Option[DateTime] = None,
    releaseTime: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = None,
    allowsMultipleInstanceTypes: Option[
      zio.aws.ec2.model.AllowsMultipleInstanceTypes
    ] = None,
    ownerId: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    memberOfServiceLinkedResourceGroup: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Host
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availableCapacity.map(value => value.buildAwsValue()))(
        _.availableCapacity
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(hostId.map(value => value: java.lang.String))(_.hostId)
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .optionallyWith(hostReservationId.map(value => value: java.lang.String))(
        _.hostReservationId
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        allocationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.allocationTime)
      .optionallyWith(
        releaseTime.map(value => DateTime.unwrap(value): Instant)
      )(_.releaseTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .optionallyWith(allowsMultipleInstanceTypes.map(value => value.unwrap))(
        _.allowsMultipleInstanceTypes
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(
        memberOfServiceLinkedResourceGroup.map(value =>
          value: java.lang.Boolean
        )
      )(_.memberOfServiceLinkedResourceGroup)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Host.ReadOnly =
    zio.aws.ec2.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Host] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Host = zio.aws.ec2.model.Host(
      autoPlacement.map(value => value),
      availabilityZone.map(value => value),
      availableCapacity.map(value => value.asEditable),
      clientToken.map(value => value),
      hostId.map(value => value),
      hostProperties.map(value => value.asEditable),
      hostReservationId.map(value => value),
      instances.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      state.map(value => value),
      allocationTime.map(value => value),
      releaseTime.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hostRecovery.map(value => value),
      allowsMultipleInstanceTypes.map(value => value),
      ownerId.map(value => value),
      availabilityZoneId.map(value => value),
      memberOfServiceLinkedResourceGroup.map(value => value)
    )
    def autoPlacement: Option[zio.aws.ec2.model.AutoPlacement]
    def availabilityZone: Option[String]
    def availableCapacity: Option[zio.aws.ec2.model.AvailableCapacity.ReadOnly]
    def clientToken: Option[String]
    def hostId: Option[String]
    def hostProperties: Option[zio.aws.ec2.model.HostProperties.ReadOnly]
    def hostReservationId: Option[String]
    def instances: Option[List[zio.aws.ec2.model.HostInstance.ReadOnly]]
    def state: Option[zio.aws.ec2.model.AllocationState]
    def allocationTime: Option[DateTime]
    def releaseTime: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def hostRecovery: Option[zio.aws.ec2.model.HostRecovery]
    def allowsMultipleInstanceTypes
        : Option[zio.aws.ec2.model.AllowsMultipleInstanceTypes]
    def ownerId: Option[String]
    def availabilityZoneId: Option[String]
    def memberOfServiceLinkedResourceGroup: Option[Boolean]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailableCapacity
        : ZIO[Any, AwsError, zio.aws.ec2.model.AvailableCapacity.ReadOnly] =
      AwsError.unwrapOptionField("availableCapacity", availableCapacity)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getHostId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getHostProperties
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostProperties.ReadOnly] =
      AwsError.unwrapOptionField("hostProperties", hostProperties)
    def getHostReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostReservationId", hostReservationId)
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HostInstance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AllocationState] =
      AwsError.unwrapOptionField("state", state)
    def getAllocationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("allocationTime", allocationTime)
    def getReleaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("releaseTime", releaseTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
    def getAllowsMultipleInstanceTypes
        : ZIO[Any, AwsError, zio.aws.ec2.model.AllowsMultipleInstanceTypes] =
      AwsError.unwrapOptionField(
        "allowsMultipleInstanceTypes",
        allowsMultipleInstanceTypes
      )
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getMemberOfServiceLinkedResourceGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "memberOfServiceLinkedResourceGroup",
        memberOfServiceLinkedResourceGroup
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Host
  ) extends zio.aws.ec2.model.Host.ReadOnly {
    override val autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = scala
      .Option(impl.autoPlacement())
      .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availableCapacity
        : Option[zio.aws.ec2.model.AvailableCapacity.ReadOnly] = scala
      .Option(impl.availableCapacity())
      .map(value => zio.aws.ec2.model.AvailableCapacity.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val hostId: Option[String] =
      scala.Option(impl.hostId()).map(value => value: String)
    override val hostProperties
        : Option[zio.aws.ec2.model.HostProperties.ReadOnly] = scala
      .Option(impl.hostProperties())
      .map(value => zio.aws.ec2.model.HostProperties.wrap(value))
    override val hostReservationId: Option[String] =
      scala.Option(impl.hostReservationId()).map(value => value: String)
    override val instances
        : Option[List[zio.aws.ec2.model.HostInstance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.HostInstance.wrap(item)
        }.toList
      )
    override val state: Option[zio.aws.ec2.model.AllocationState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.AllocationState.wrap(value))
    override val allocationTime: Option[DateTime] = scala
      .Option(impl.allocationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val releaseTime: Option[DateTime] = scala
      .Option(impl.releaseTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = scala
      .Option(impl.hostRecovery())
      .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
    override val allowsMultipleInstanceTypes
        : Option[zio.aws.ec2.model.AllowsMultipleInstanceTypes] = scala
      .Option(impl.allowsMultipleInstanceTypes())
      .map(value => zio.aws.ec2.model.AllowsMultipleInstanceTypes.wrap(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val memberOfServiceLinkedResourceGroup: Option[Boolean] = scala
      .Option(impl.memberOfServiceLinkedResourceGroup())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Host
  ): zio.aws.ec2.model.Host.ReadOnly = new Wrapper(impl)
}
