package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsMaxResults,
  NetworkInsightsAccessScopeAnalysisId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetNetworkInsightsAccessScopeAnalysisFindingsRequest(
    networkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId,
    maxResults: Option[NetworkInsightsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest = {
    import GetNetworkInsightsAccessScopeAnalysisFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
      .builder()
      .networkInsightsAccessScopeAnalysisId(
        NetworkInsightsAccessScopeAnalysisId.unwrap(
          networkInsightsAccessScopeAnalysisId
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly =
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
      .wrap(buildAwsValue())
}
object GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest =
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest(
        networkInsightsAccessScopeAnalysisId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId
    def maxResults: Option[NetworkInsightsMaxResults]
    def nextToken: Option[NextToken]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeAnalysisId] =
      ZIO.succeed(networkInsightsAccessScopeAnalysisId)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ) extends zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId =
      zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(
        impl.networkInsightsAccessScopeAnalysisId()
      )
    override val maxResults: Option[NetworkInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
