package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  CapacityReservationId,
  IntegerWithConstraints,
  DoubleWithConstraints,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FleetCapacityReservation(
    capacityReservationId: Option[CapacityReservationId] = None,
    availabilityZoneId: Option[String] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    instancePlatform: Option[
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = None,
    availabilityZone: Option[String] = None,
    totalInstanceCount: Option[Integer] = None,
    fulfilledCapacity: Option[Double] = None,
    ebsOptimized: Option[Boolean] = None,
    createDate: Option[MillisecondDateTime] = None,
    weight: Option[DoubleWithConstraints] = None,
    priority: Option[IntegerWithConstraints] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetCapacityReservation = {
    import FleetCapacityReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
      .builder()
      .optionallyWith(
        capacityReservationId.map(value =>
          CapacityReservationId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationId)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(instancePlatform.map(value => value.unwrap))(
        _.instancePlatform
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        totalInstanceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalInstanceCount)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        createDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(
        weight.map(value =>
          DoubleWithConstraints.unwrap(value): java.lang.Double
        )
      )(_.weight)
      .optionallyWith(
        priority.map(value =>
          IntegerWithConstraints.unwrap(value): java.lang.Integer
        )
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetCapacityReservation.ReadOnly =
    zio.aws.ec2.model.FleetCapacityReservation.wrap(buildAwsValue())
}
object FleetCapacityReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetCapacityReservation =
      zio.aws.ec2.model.FleetCapacityReservation(
        capacityReservationId.map(value => value),
        availabilityZoneId.map(value => value),
        instanceType.map(value => value),
        instancePlatform.map(value => value),
        availabilityZone.map(value => value),
        totalInstanceCount.map(value => value),
        fulfilledCapacity.map(value => value),
        ebsOptimized.map(value => value),
        createDate.map(value => value),
        weight.map(value => value),
        priority.map(value => value)
      )
    def capacityReservationId: Option[CapacityReservationId]
    def availabilityZoneId: Option[String]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform]
    def availabilityZone: Option[String]
    def totalInstanceCount: Option[Integer]
    def fulfilledCapacity: Option[Double]
    def ebsOptimized: Option[Boolean]
    def createDate: Option[MillisecondDateTime]
    def weight: Option[DoubleWithConstraints]
    def priority: Option[IntegerWithConstraints]
    def getCapacityReservationId: ZIO[Any, AwsError, CapacityReservationId] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstancePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = AwsError.unwrapOptionField("instancePlatform", instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTotalInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalInstanceCount", totalInstanceCount)
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getCreateDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getWeight: ZIO[Any, AwsError, DoubleWithConstraints] =
      AwsError.unwrapOptionField("weight", weight)
    def getPriority: ZIO[Any, AwsError, IntegerWithConstraints] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ) extends zio.aws.ec2.model.FleetCapacityReservation.ReadOnly {
    override val capacityReservationId: Option[CapacityReservationId] = scala
      .Option(impl.capacityReservationId())
      .map(value => zio.aws.ec2.model.primitives.CapacityReservationId(value))
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform] = scala
      .Option(impl.instancePlatform())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationInstancePlatform.wrap(value)
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val totalInstanceCount: Option[Integer] = scala
      .Option(impl.totalInstanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val fulfilledCapacity: Option[Double] =
      scala.Option(impl.fulfilledCapacity()).map(value => value: Double)
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val createDate: Option[MillisecondDateTime] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val weight: Option[DoubleWithConstraints] = scala
      .Option(impl.weight())
      .map(value => zio.aws.ec2.model.primitives.DoubleWithConstraints(value))
    override val priority: Option[IntegerWithConstraints] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ec2.model.primitives.IntegerWithConstraints(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ): zio.aws.ec2.model.FleetCapacityReservation.ReadOnly = new Wrapper(impl)
}
