package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableVpcClassicLinkDnsSupportRequest(
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest = {
    import EnableVpcClassicLinkDnsSupportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest
      .builder()
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest.ReadOnly =
    zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest
      .wrap(buildAwsValue())
}
object EnableVpcClassicLinkDnsSupportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest =
      zio.aws.ec2.model
        .EnableVpcClassicLinkDnsSupportRequest(vpcId.map(value => value))
    def vpcId: Option[VpcId]
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest
  ) extends zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest.ReadOnly {
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest
  ): zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest.ReadOnly =
    new Wrapper(impl)
}
