package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableFastSnapshotRestoreErrorItem(
    snapshotId: Option[String] = None,
    fastSnapshotRestoreStateErrors: Option[
      Iterable[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem = {
    import DisableFastSnapshotRestoreErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastSnapshotRestoreStateErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly =
    zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.wrap(buildAwsValue())
}
object DisableFastSnapshotRestoreErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem =
      zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem(
        snapshotId.map(value => value),
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotId: Option[String]
    def fastSnapshotRestoreStateErrors: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getFastSnapshotRestoreStateErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fastSnapshotRestoreStateErrors",
      fastSnapshotRestoreStateErrors
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ) extends zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val fastSnapshotRestoreStateErrors: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ] = scala
      .Option(impl.fastSnapshotRestoreStateErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ): zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly =
    new Wrapper(impl)
}
