package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointsResponse(
    vpcEndpoints: Option[Iterable[zio.aws.ec2.model.VpcEndpoint]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse = {
    import DescribeVpcEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse
      .builder()
      .optionallyWith(
        vpcEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpoints)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointsResponse.wrap(buildAwsValue())
}
object DescribeVpcEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcEndpointsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointsResponse(
        vpcEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpcEndpoints: Option[List[zio.aws.ec2.model.VpcEndpoint.ReadOnly]]
    def nextToken: Option[String]
    def getVpcEndpoints
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpcEndpoint.ReadOnly]] =
      AwsError.unwrapOptionField("vpcEndpoints", vpcEndpoints)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly {
    override val vpcEndpoints
        : Option[List[zio.aws.ec2.model.VpcEndpoint.ReadOnly]] = scala
      .Option(impl.vpcEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpcEndpoint.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly = new Wrapper(impl)
}
