package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  TrafficMirroringMaxResults,
  TrafficMirrorFilterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorFiltersRequest(
    trafficMirrorFilterIds: Option[Iterable[TrafficMirrorFilterId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TrafficMirroringMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest = {
    import DescribeTrafficMirrorFiltersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
      .builder()
      .optionallyWith(
        trafficMirrorFilterIds.map(value =>
          value.map { item =>
            TrafficMirrorFilterId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trafficMirrorFilterIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          TrafficMirroringMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.wrap(buildAwsValue())
}
object DescribeTrafficMirrorFiltersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest =
      zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest(
        trafficMirrorFilterIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trafficMirrorFilterIds: Option[List[TrafficMirrorFilterId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TrafficMirroringMaxResults]
    def nextToken: Option[NextToken]
    def getTrafficMirrorFilterIds
        : ZIO[Any, AwsError, List[TrafficMirrorFilterId]] = AwsError
      .unwrapOptionField("trafficMirrorFilterIds", trafficMirrorFilterIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TrafficMirroringMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly {
    override val trafficMirrorFilterIds: Option[List[TrafficMirrorFilterId]] =
      scala
        .Option(impl.trafficMirrorFilterIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrafficMirrorFilterId(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TrafficMirroringMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TrafficMirroringMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly =
    new Wrapper(impl)
}
