package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{LocalGatewayMaxResults, LocalGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewaysRequest(
    localGatewayIds: Option[Iterable[LocalGatewayId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[LocalGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest = {
    import DescribeLocalGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest
      .builder()
      .optionallyWith(
        localGatewayIds.map(value =>
          value.map { item =>
            LocalGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LocalGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeLocalGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewaysRequest.wrap(buildAwsValue())
}
object DescribeLocalGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLocalGatewaysRequest =
      zio.aws.ec2.model.DescribeLocalGatewaysRequest(
        localGatewayIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localGatewayIds: Option[List[LocalGatewayId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[LocalGatewayMaxResults]
    def nextToken: Option[String]
    def getLocalGatewayIds: ZIO[Any, AwsError, List[LocalGatewayId]] =
      AwsError.unwrapOptionField("localGatewayIds", localGatewayIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LocalGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeLocalGatewaysRequest.ReadOnly {
    override val localGatewayIds: Option[List[LocalGatewayId]] = scala
      .Option(impl.localGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LocalGatewayId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[LocalGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest
  ): zio.aws.ec2.model.DescribeLocalGatewaysRequest.ReadOnly = new Wrapper(impl)
}
