package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayVirtualInterfaceGroupsResponse(
    localGatewayVirtualInterfaceGroups: Option[
      Iterable[zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse = {
    import DescribeLocalGatewayVirtualInterfaceGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayVirtualInterfaceGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayVirtualInterfaceGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse =
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse(
        localGatewayVirtualInterfaceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGatewayVirtualInterfaceGroups: Option[
      List[zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly]
    ]
    def nextToken: Option[String]
    def getLocalGatewayVirtualInterfaceGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localGatewayVirtualInterfaceGroups",
      localGatewayVirtualInterfaceGroups
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly {
    override val localGatewayVirtualInterfaceGroups: Option[
      List[zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly]
    ] = scala
      .Option(impl.localGatewayVirtualInterfaceGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
