package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationsResponse(
    hostReservationSet: Option[Iterable[zio.aws.ec2.model.HostReservation]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse = {
    import DescribeHostReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
      .builder()
      .optionallyWith(
        hostReservationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hostReservationSet)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationsResponse.wrap(buildAwsValue())
}
object DescribeHostReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationsResponse =
      zio.aws.ec2.model.DescribeHostReservationsResponse(
        hostReservationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hostReservationSet
        : Option[List[zio.aws.ec2.model.HostReservation.ReadOnly]]
    def nextToken: Option[String]
    def getHostReservationSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HostReservation.ReadOnly]] =
      AwsError.unwrapOptionField("hostReservationSet", hostReservationSet)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ) extends zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly {
    override val hostReservationSet
        : Option[List[zio.aws.ec2.model.HostReservation.ReadOnly]] = scala
      .Option(impl.hostReservationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.HostReservation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ): zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
