package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  OfferingId,
  DescribeHostReservationsMaxResults,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationOfferingsRequest(
    filter: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxDuration: Option[Integer] = None,
    maxResults: Option[DescribeHostReservationsMaxResults] = None,
    minDuration: Option[Integer] = None,
    nextToken: Option[String] = None,
    offeringId: Option[OfferingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest = {
    import DescribeHostReservationOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        maxDuration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxDuration)
      .optionallyWith(
        maxResults.map(value =>
          DescribeHostReservationsMaxResults.unwrap(value): java.lang.Integer
        )
      )(_.maxResults)
      .optionallyWith(
        minDuration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.minDuration)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        offeringId.map(value => OfferingId.unwrap(value): java.lang.String)
      )(_.offeringId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeHostReservationOfferingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeHostReservationOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest =
      zio.aws.ec2.model.DescribeHostReservationOfferingsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxDuration.map(value => value),
        maxResults.map(value => value),
        minDuration.map(value => value),
        nextToken.map(value => value),
        offeringId.map(value => value)
      )
    def filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxDuration: Option[Integer]
    def maxResults: Option[DescribeHostReservationsMaxResults]
    def minDuration: Option[Integer]
    def nextToken: Option[String]
    def offeringId: Option[OfferingId]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxResults: ZIO[Any, AwsError, DescribeHostReservationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMinDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minDuration", minDuration)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOfferingId: ZIO[Any, AwsError, OfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest
  ) extends zio.aws.ec2.model.DescribeHostReservationOfferingsRequest.ReadOnly {
    override val filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Filter.wrap(item)
        }.toList
      )
    override val maxDuration: Option[Integer] = scala
      .Option(impl.maxDuration())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val maxResults: Option[DescribeHostReservationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeHostReservationsMaxResults(value)
      )
    override val minDuration: Option[Integer] = scala
      .Option(impl.minDuration())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val offeringId: Option[OfferingId] = scala
      .Option(impl.offeringId())
      .map(value => zio.aws.ec2.model.primitives.OfferingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest
  ): zio.aws.ec2.model.DescribeHostReservationOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
