package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{FleetId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    fleetIds: Option[Iterable[FleetId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest = {
    import DescribeFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        fleetIds.map(value =>
          value.map { item =>
            FleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleetIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFleetsRequest.wrap(buildAwsValue())
}
object DescribeFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetsRequest =
      zio.aws.ec2.model.DescribeFleetsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        fleetIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def fleetIds: Option[List[FleetId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetIds: ZIO[Any, AwsError, List[FleetId]] =
      AwsError.unwrapOptionField("fleetIds", fleetIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest
  ) extends zio.aws.ec2.model.DescribeFleetsRequest.ReadOnly {
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val fleetIds: Option[List[FleetId]] = scala
      .Option(impl.fleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.FleetId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest
  ): zio.aws.ec2.model.DescribeFleetsRequest.ReadOnly = new Wrapper(impl)
}
