package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAddressesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    publicIps: Option[Iterable[String]] = None,
    allocationIds: Option[Iterable[AllocationId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest = {
    import DescribeAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        publicIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicIps)
      .optionallyWith(
        allocationIds.map(value =>
          value.map { item =>
            AllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allocationIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesRequest.wrap(buildAwsValue())
}
object DescribeAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesRequest =
      zio.aws.ec2.model.DescribeAddressesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicIps.map(value => value),
        allocationIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def publicIps: Option[List[String]]
    def allocationIds: Option[List[AllocationId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getPublicIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicIps", publicIps)
    def getAllocationIds: ZIO[Any, AwsError, List[AllocationId]] =
      AwsError.unwrapOptionField("allocationIds", allocationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest
  ) extends zio.aws.ec2.model.DescribeAddressesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val publicIps: Option[List[String]] = scala
      .Option(impl.publicIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allocationIds: Option[List[AllocationId]] = scala
      .Option(impl.allocationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.AllocationId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest
  ): zio.aws.ec2.model.DescribeAddressesRequest.ReadOnly = new Wrapper(impl)
}
