package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConnectionNotificationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointConnectionNotificationsRequest(
    connectionNotificationIds: Iterable[ConnectionNotificationId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest = {
    import DeleteVpcEndpointConnectionNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
      .builder()
      .connectionNotificationIds(connectionNotificationIds.map { item =>
        ConnectionNotificationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointConnectionNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest =
      zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest(
        connectionNotificationIds
      )
    def connectionNotificationIds: List[ConnectionNotificationId]
    def getConnectionNotificationIds
        : ZIO[Any, Nothing, List[ConnectionNotificationId]] =
      ZIO.succeed(connectionNotificationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ) extends zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly {
    override val connectionNotificationIds: List[ConnectionNotificationId] =
      impl
        .connectionNotificationIds()
        .asScala
        .map { item =>
          zio.aws.ec2.model.primitives.ConnectionNotificationId(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ): zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
