package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FpgaImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFpgaImageRequest(fpgaImageId: FpgaImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest = {
    import DeleteFpgaImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest
      .builder()
      .fpgaImageId(FpgaImageId.unwrap(fpgaImageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFpgaImageRequest.ReadOnly =
    zio.aws.ec2.model.DeleteFpgaImageRequest.wrap(buildAwsValue())
}
object DeleteFpgaImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFpgaImageRequest =
      zio.aws.ec2.model.DeleteFpgaImageRequest(fpgaImageId)
    def fpgaImageId: FpgaImageId
    def getFpgaImageId: ZIO[Any, Nothing, FpgaImageId] =
      ZIO.succeed(fpgaImageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest
  ) extends zio.aws.ec2.model.DeleteFpgaImageRequest.ReadOnly {
    override val fpgaImageId: FpgaImageId =
      zio.aws.ec2.model.primitives.FpgaImageId(impl.fpgaImageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest
  ): zio.aws.ec2.model.DeleteFpgaImageRequest.ReadOnly = new Wrapper(impl)
}
