package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpnGatewayRequest(
    availabilityZone: Option[String] = None,
    `type`: zio.aws.ec2.model.GatewayType,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    amazonSideAsn: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest = {
    import CreateVpnGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .`type`(`type`.unwrap)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(
        _.amazonSideAsn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnGatewayRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpnGatewayRequest.wrap(buildAwsValue())
}
object CreateVpnGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnGatewayRequest =
      zio.aws.ec2.model.CreateVpnGatewayRequest(
        availabilityZone.map(value => value),
        `type`,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        amazonSideAsn.map(value => value)
      )
    def availabilityZone: Option[String]
    def `type`: zio.aws.ec2.model.GatewayType
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def amazonSideAsn: Option[Long]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getType: ZIO[Any, Nothing, zio.aws.ec2.model.GatewayType] =
      ZIO.succeed(`type`)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getAmazonSideAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest
  ) extends zio.aws.ec2.model.CreateVpnGatewayRequest.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val `type`: zio.aws.ec2.model.GatewayType =
      zio.aws.ec2.model.GatewayType.wrap(impl.`type`())
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val amazonSideAsn: Option[Long] =
      scala.Option(impl.amazonSideAsn()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest
  ): zio.aws.ec2.model.CreateVpnGatewayRequest.ReadOnly = new Wrapper(impl)
}
