package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLaunchTemplateResponse(
    launchTemplate: Option[zio.aws.ec2.model.LaunchTemplate] = None,
    warning: Option[zio.aws.ec2.model.ValidationWarning] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse = {
    import CreateLaunchTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse
      .builder()
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(warning.map(value => value.buildAwsValue()))(_.warning)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly =
    zio.aws.ec2.model.CreateLaunchTemplateResponse.wrap(buildAwsValue())
}
object CreateLaunchTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLaunchTemplateResponse =
      zio.aws.ec2.model.CreateLaunchTemplateResponse(
        launchTemplate.map(value => value.asEditable),
        warning.map(value => value.asEditable)
      )
    def launchTemplate: Option[zio.aws.ec2.model.LaunchTemplate.ReadOnly]
    def warning: Option[zio.aws.ec2.model.ValidationWarning.ReadOnly]
    def getLaunchTemplate
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplate.ReadOnly] =
      AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getWarning
        : ZIO[Any, AwsError, zio.aws.ec2.model.ValidationWarning.ReadOnly] =
      AwsError.unwrapOptionField("warning", warning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse
  ) extends zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly {
    override val launchTemplate
        : Option[zio.aws.ec2.model.LaunchTemplate.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.ec2.model.LaunchTemplate.wrap(value))
    override val warning: Option[zio.aws.ec2.model.ValidationWarning.ReadOnly] =
      scala
        .Option(impl.warning())
        .map(value => zio.aws.ec2.model.ValidationWarning.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse
  ): zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly = new Wrapper(impl)
}
