package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    clientToken: Option[String] = None,
    spotOptions: Option[zio.aws.ec2.model.SpotOptionsRequest] = None,
    onDemandOptions: Option[zio.aws.ec2.model.OnDemandOptionsRequest] = None,
    excessCapacityTerminationPolicy: Option[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = None,
    launchTemplateConfigs: Iterable[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest
    ],
    targetCapacitySpecification: zio.aws.ec2.model.TargetCapacitySpecificationRequest,
    terminateInstancesWithExpiration: Option[Boolean] = None,
    `type`: Option[zio.aws.ec2.model.FleetType] = None,
    validFrom: Option[DateTime] = None,
    validUntil: Option[DateTime] = None,
    replaceUnhealthyInstances: Option[Boolean] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    context: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFleetRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(onDemandOptions.map(value => value.buildAwsValue()))(
        _.onDemandOptions
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .launchTemplateConfigs(launchTemplateConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .targetCapacitySpecification(targetCapacitySpecification.buildAwsValue())
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFleetRequest.ReadOnly =
    zio.aws.ec2.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFleetRequest =
      zio.aws.ec2.model.CreateFleetRequest(
        clientToken.map(value => value),
        spotOptions.map(value => value.asEditable),
        onDemandOptions.map(value => value.asEditable),
        excessCapacityTerminationPolicy.map(value => value),
        launchTemplateConfigs.map { item =>
          item.asEditable
        },
        targetCapacitySpecification.asEditable,
        terminateInstancesWithExpiration.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        replaceUnhealthyInstances.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        context.map(value => value)
      )
    def clientToken: Option[String]
    def spotOptions: Option[zio.aws.ec2.model.SpotOptionsRequest.ReadOnly]
    def onDemandOptions
        : Option[zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly]
    def excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def launchTemplateConfigs
        : List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    def targetCapacitySpecification
        : zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    def terminateInstancesWithExpiration: Option[Boolean]
    def `type`: Option[zio.aws.ec2.model.FleetType]
    def validFrom: Option[DateTime]
    def validUntil: Option[DateTime]
    def replaceUnhealthyInstances: Option[Boolean]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def context: Option[String]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getOnDemandOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandOptions", onDemandOptions)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getLaunchTemplateConfigs: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly
    ]] = ZIO.succeed(launchTemplateConfigs)
    def getTargetCapacitySpecification: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = ZIO.succeed(targetCapacitySpecification)
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ) extends zio.aws.ec2.model.CreateFleetRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val spotOptions
        : Option[zio.aws.ec2.model.SpotOptionsRequest.ReadOnly] = scala
      .Option(impl.spotOptions())
      .map(value => zio.aws.ec2.model.SpotOptionsRequest.wrap(value))
    override val onDemandOptions
        : Option[zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly] = scala
      .Option(impl.onDemandOptions())
      .map(value => zio.aws.ec2.model.OnDemandOptionsRequest.wrap(value))
    override val excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] = scala
      .Option(impl.excessCapacityTerminationPolicy())
      .map(value =>
        zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
      )
    override val launchTemplateConfigs
        : List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly] =
      impl
        .launchTemplateConfigs()
        .asScala
        .map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(item)
        }
        .toList
    override val targetCapacitySpecification
        : zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly =
      zio.aws.ec2.model.TargetCapacitySpecificationRequest
        .wrap(impl.targetCapacitySpecification())
    override val terminateInstancesWithExpiration: Option[Boolean] = scala
      .Option(impl.terminateInstancesWithExpiration())
      .map(value => value: Boolean)
    override val `type`: Option[zio.aws.ec2.model.FleetType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Option[DateTime] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Option[Boolean] = scala
      .Option(impl.replaceUnhealthyInstances())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ): zio.aws.ec2.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
