package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientLoginBannerOptions(
    enabled: Option[Boolean] = None,
    bannerText: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions = {
    import ClientLoginBannerOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(bannerText.map(value => value: java.lang.String))(
        _.bannerText
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly =
    zio.aws.ec2.model.ClientLoginBannerOptions.wrap(buildAwsValue())
}
object ClientLoginBannerOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientLoginBannerOptions =
      zio.aws.ec2.model.ClientLoginBannerOptions(
        enabled.map(value => value),
        bannerText.map(value => value)
      )
    def enabled: Option[Boolean]
    def bannerText: Option[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBannerText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bannerText", bannerText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions
  ) extends zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val bannerText: Option[String] =
      scala.Option(impl.bannerText()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions
  ): zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly = new Wrapper(impl)
}
