package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CapacityReservationTargetResponse(
    capacityReservationId: Option[String] = None,
    capacityReservationResourceGroupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse = {
    import CapacityReservationTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse
      .builder()
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationResourceGroupArn.map(value =>
          value: java.lang.String
        )
      )(_.capacityReservationResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly =
    zio.aws.ec2.model.CapacityReservationTargetResponse.wrap(buildAwsValue())
}
object CapacityReservationTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationTargetResponse =
      zio.aws.ec2.model.CapacityReservationTargetResponse(
        capacityReservationId.map(value => value),
        capacityReservationResourceGroupArn.map(value => value)
      )
    def capacityReservationId: Option[String]
    def capacityReservationResourceGroupArn: Option[String]
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationResourceGroupArn",
        capacityReservationResourceGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse
  ) extends zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly {
    override val capacityReservationId: Option[String] =
      scala.Option(impl.capacityReservationId()).map(value => value: String)
    override val capacityReservationResourceGroupArn: Option[String] = scala
      .Option(impl.capacityReservationResourceGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse
  ): zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly = new Wrapper(
    impl
  )
}
