package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NetmaskLength,
  IpamPoolId,
  Ipv6PoolEc2Id,
  VpcId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateVpcCidrBlockRequest(
    amazonProvidedIpv6CidrBlock: Option[Boolean] = None,
    cidrBlock: Option[String] = None,
    vpcId: VpcId,
    ipv6CidrBlockNetworkBorderGroup: Option[String] = None,
    ipv6Pool: Option[Ipv6PoolEc2Id] = None,
    ipv6CidrBlock: Option[String] = None,
    ipv4IpamPoolId: Option[IpamPoolId] = None,
    ipv4NetmaskLength: Option[NetmaskLength] = None,
    ipv6IpamPoolId: Option[IpamPoolId] = None,
    ipv6NetmaskLength: Option[NetmaskLength] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest = {
    import AssociateVpcCidrBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest
      .builder()
      .optionallyWith(
        amazonProvidedIpv6CidrBlock.map(value => value: java.lang.Boolean)
      )(_.amazonProvidedIpv6CidrBlock)
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(
        ipv6CidrBlockNetworkBorderGroup.map(value => value: java.lang.String)
      )(_.ipv6CidrBlockNetworkBorderGroup)
      .optionallyWith(
        ipv6Pool.map(value => Ipv6PoolEc2Id.unwrap(value): java.lang.String)
      )(_.ipv6Pool)
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(
        ipv4IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv4IpamPoolId)
      .optionallyWith(
        ipv4NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv4NetmaskLength)
      .optionallyWith(
        ipv6IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv6IpamPoolId)
      .optionallyWith(
        ipv6NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv6NetmaskLength)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateVpcCidrBlockRequest.ReadOnly =
    zio.aws.ec2.model.AssociateVpcCidrBlockRequest.wrap(buildAwsValue())
}
object AssociateVpcCidrBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateVpcCidrBlockRequest =
      zio.aws.ec2.model.AssociateVpcCidrBlockRequest(
        amazonProvidedIpv6CidrBlock.map(value => value),
        cidrBlock.map(value => value),
        vpcId,
        ipv6CidrBlockNetworkBorderGroup.map(value => value),
        ipv6Pool.map(value => value),
        ipv6CidrBlock.map(value => value),
        ipv4IpamPoolId.map(value => value),
        ipv4NetmaskLength.map(value => value),
        ipv6IpamPoolId.map(value => value),
        ipv6NetmaskLength.map(value => value)
      )
    def amazonProvidedIpv6CidrBlock: Option[Boolean]
    def cidrBlock: Option[String]
    def vpcId: VpcId
    def ipv6CidrBlockNetworkBorderGroup: Option[String]
    def ipv6Pool: Option[Ipv6PoolEc2Id]
    def ipv6CidrBlock: Option[String]
    def ipv4IpamPoolId: Option[IpamPoolId]
    def ipv4NetmaskLength: Option[NetmaskLength]
    def ipv6IpamPoolId: Option[IpamPoolId]
    def ipv6NetmaskLength: Option[NetmaskLength]
    def getAmazonProvidedIpv6CidrBlock: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "amazonProvidedIpv6CidrBlock",
        amazonProvidedIpv6CidrBlock
      )
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getIpv6CidrBlockNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ipv6CidrBlockNetworkBorderGroup",
        ipv6CidrBlockNetworkBorderGroup
      )
    def getIpv6Pool: ZIO[Any, AwsError, Ipv6PoolEc2Id] =
      AwsError.unwrapOptionField("ipv6Pool", ipv6Pool)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getIpv4IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv4IpamPoolId", ipv4IpamPoolId)
    def getIpv4NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv4NetmaskLength", ipv4NetmaskLength)
    def getIpv6IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv6IpamPoolId", ipv6IpamPoolId)
    def getIpv6NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv6NetmaskLength", ipv6NetmaskLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest
  ) extends zio.aws.ec2.model.AssociateVpcCidrBlockRequest.ReadOnly {
    override val amazonProvidedIpv6CidrBlock: Option[Boolean] = scala
      .Option(impl.amazonProvidedIpv6CidrBlock())
      .map(value => value: Boolean)
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val ipv6CidrBlockNetworkBorderGroup: Option[String] = scala
      .Option(impl.ipv6CidrBlockNetworkBorderGroup())
      .map(value => value: String)
    override val ipv6Pool: Option[Ipv6PoolEc2Id] = scala
      .Option(impl.ipv6Pool())
      .map(value => zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(value))
    override val ipv6CidrBlock: Option[String] =
      scala.Option(impl.ipv6CidrBlock()).map(value => value: String)
    override val ipv4IpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipv4IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv4NetmaskLength: Option[NetmaskLength] = scala
      .Option(impl.ipv4NetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
    override val ipv6IpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipv6IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv6NetmaskLength: Option[NetmaskLength] = scala
      .Option(impl.ipv6NetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest
  ): zio.aws.ec2.model.AssociateVpcCidrBlockRequest.ReadOnly = new Wrapper(impl)
}
