package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AllocateIpamPoolCidrResponse(
    ipamPoolAllocation: Option[zio.aws.ec2.model.IpamPoolAllocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse = {
    import AllocateIpamPoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
      .builder()
      .optionallyWith(ipamPoolAllocation.map(value => value.buildAwsValue()))(
        _.ipamPoolAllocation
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.AllocateIpamPoolCidrResponse.wrap(buildAwsValue())
}
object AllocateIpamPoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateIpamPoolCidrResponse =
      zio.aws.ec2.model.AllocateIpamPoolCidrResponse(
        ipamPoolAllocation.map(value => value.asEditable)
      )
    def ipamPoolAllocation
        : Option[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly]
    def getIpamPoolAllocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocation.ReadOnly] =
      AwsError.unwrapOptionField("ipamPoolAllocation", ipamPoolAllocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ) extends zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly {
    override val ipamPoolAllocation
        : Option[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly] = scala
      .Option(impl.ipamPoolAllocation())
      .map(value => zio.aws.ec2.model.IpamPoolAllocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ): zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly = new Wrapper(impl)
}
