package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddIpamOperatingRegion(regionName: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion = {
    import AddIpamOperatingRegion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion
      .builder()
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly =
    zio.aws.ec2.model.AddIpamOperatingRegion.wrap(buildAwsValue())
}
object AddIpamOperatingRegion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddIpamOperatingRegion =
      zio.aws.ec2.model.AddIpamOperatingRegion(regionName.map(value => value))
    def regionName: Option[String]
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion
  ) extends zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly {
    override val regionName: Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion
  ): zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly = new Wrapper(impl)
}
