package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcAttachment(
    state: Option[zio.aws.ec2.model.AttachmentStatus] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcAttachment = {
    import VpcAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcAttachment
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcAttachment.ReadOnly =
    zio.aws.ec2.model.VpcAttachment.wrap(buildAwsValue())
}
object VpcAttachment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpcAttachment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcAttachment = zio.aws.ec2.model
      .VpcAttachment(state.map(value => value), vpcId.map(value => value))
    def state: Option[zio.aws.ec2.model.AttachmentStatus]
    def vpcId: Option[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("state", state)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcAttachment
  ) extends zio.aws.ec2.model.VpcAttachment.ReadOnly {
    override val state: Option[zio.aws.ec2.model.AttachmentStatus] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcAttachment
  ): zio.aws.ec2.model.VpcAttachment.ReadOnly = new Wrapper(impl)
}
