package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TunnelInsideIpVersion {
  def unwrap: software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion
}
object TunnelInsideIpVersion {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion
  ): zio.aws.ec2.model.TunnelInsideIpVersion = value match {
    case software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.IPV6 =>
      val r = ipv6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TunnelInsideIpVersion {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion =
      software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.ec2.model.TunnelInsideIpVersion {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion =
      software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.IPV4
  }
  case object ipv6 extends zio.aws.ec2.model.TunnelInsideIpVersion {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion =
      software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion.IPV6
  }
}
