package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectPeerConfiguration(
    transitGatewayAddress: Option[String] = None,
    peerAddress: Option[String] = None,
    insideCidrBlocks: Option[Iterable[String]] = None,
    protocol: Option[zio.aws.ec2.model.ProtocolValue] = None,
    bgpConfigurations: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration = {
    import TransitGatewayConnectPeerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
      .builder()
      .optionallyWith(
        transitGatewayAddress.map(value => value: java.lang.String)
      )(_.transitGatewayAddress)
      .optionallyWith(peerAddress.map(value => value: java.lang.String))(
        _.peerAddress
      )
      .optionallyWith(
        insideCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insideCidrBlocks)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        bgpConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bgpConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration
      .wrap(buildAwsValue())
}
object TransitGatewayConnectPeerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration =
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration(
        transitGatewayAddress.map(value => value),
        peerAddress.map(value => value),
        insideCidrBlocks.map(value => value),
        protocol.map(value => value),
        bgpConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAddress: Option[String]
    def peerAddress: Option[String]
    def insideCidrBlocks: Option[List[String]]
    def protocol: Option[zio.aws.ec2.model.ProtocolValue]
    def bgpConfigurations: Option[
      List[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly]
    ]
    def getTransitGatewayAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayAddress", transitGatewayAddress)
    def getPeerAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
    def getInsideCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("insideCidrBlocks", insideCidrBlocks)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.ProtocolValue] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBgpConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("bgpConfigurations", bgpConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ) extends zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly {
    override val transitGatewayAddress: Option[String] =
      scala.Option(impl.transitGatewayAddress()).map(value => value: String)
    override val peerAddress: Option[String] =
      scala.Option(impl.peerAddress()).map(value => value: String)
    override val insideCidrBlocks: Option[List[String]] = scala
      .Option(impl.insideCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val protocol: Option[zio.aws.ec2.model.ProtocolValue] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ec2.model.ProtocolValue.wrap(value))
    override val bgpConfigurations: Option[
      List[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly]
    ] = scala
      .Option(impl.bgpConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ): zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly =
    new Wrapper(impl)
}
