package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficMirrorRuleAction {
  def unwrap: software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction
}
object TrafficMirrorRuleAction {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction
  ): zio.aws.ec2.model.TrafficMirrorRuleAction = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.ACCEPT =>
      val r = accept
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.REJECT =>
      val r = reject
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TrafficMirrorRuleAction {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.UNKNOWN_TO_SDK_VERSION
  }
  case object accept extends zio.aws.ec2.model.TrafficMirrorRuleAction {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.ACCEPT
  }
  case object reject extends zio.aws.ec2.model.TrafficMirrorRuleAction {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction.REJECT
  }
}
