package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficMirrorFilterRuleField {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField
}
object TrafficMirrorFilterRuleField {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField
  ): zio.aws.ec2.model.TrafficMirrorFilterRuleField = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.DESTINATION_PORT_RANGE =>
      val r = `destination-port-range`
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.SOURCE_PORT_RANGE =>
      val r = `source-port-range`
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.PROTOCOL =>
      val r = protocol
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.DESCRIPTION =>
      val r = description
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TrafficMirrorFilterRuleField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.UNKNOWN_TO_SDK_VERSION
  }
  case object `destination-port-range`
      extends zio.aws.ec2.model.TrafficMirrorFilterRuleField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.DESTINATION_PORT_RANGE
  }
  case object `source-port-range`
      extends zio.aws.ec2.model.TrafficMirrorFilterRuleField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.SOURCE_PORT_RANGE
  }
  case object protocol extends zio.aws.ec2.model.TrafficMirrorFilterRuleField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.PROTOCOL
  }
  case object description
      extends zio.aws.ec2.model.TrafficMirrorFilterRuleField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField.DESCRIPTION
  }
}
