package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficDirection {
  def unwrap: software.amazon.awssdk.services.ec2.model.TrafficDirection
}
object TrafficDirection {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficDirection
  ): zio.aws.ec2.model.TrafficDirection = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficDirection.INGRESS =>
      val r = ingress
      r
    case software.amazon.awssdk.services.ec2.model.TrafficDirection.EGRESS =>
      val r = egress
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TrafficDirection {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficDirection =
      software.amazon.awssdk.services.ec2.model.TrafficDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object ingress extends zio.aws.ec2.model.TrafficDirection {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficDirection =
      software.amazon.awssdk.services.ec2.model.TrafficDirection.INGRESS
  }
  case object egress extends zio.aws.ec2.model.TrafficDirection {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficDirection =
      software.amazon.awssdk.services.ec2.model.TrafficDirection.EGRESS
  }
}
