package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  PrefixListResourceId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleRequest(
    ipProtocol: Option[String] = None,
    fromPort: Option[Integer] = None,
    toPort: Option[Integer] = None,
    cidrIpv4: Option[String] = None,
    cidrIpv6: Option[String] = None,
    prefixListId: Option[PrefixListResourceId] = None,
    referencedGroupId: Option[SecurityGroupId] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest = {
    import SecurityGroupRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
      .builder()
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(cidrIpv4.map(value => value: java.lang.String))(
        _.cidrIpv4
      )
      .optionallyWith(cidrIpv6.map(value => value: java.lang.String))(
        _.cidrIpv6
      )
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(
        referencedGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.referencedGroupId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleRequest.wrap(buildAwsValue())
}
object SecurityGroupRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleRequest =
      zio.aws.ec2.model.SecurityGroupRuleRequest(
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        cidrIpv4.map(value => value),
        cidrIpv6.map(value => value),
        prefixListId.map(value => value),
        referencedGroupId.map(value => value),
        description.map(value => value)
      )
    def ipProtocol: Option[String]
    def fromPort: Option[Integer]
    def toPort: Option[Integer]
    def cidrIpv4: Option[String]
    def cidrIpv6: Option[String]
    def prefixListId: Option[PrefixListResourceId]
    def referencedGroupId: Option[SecurityGroupId]
    def description: Option[String]
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getCidrIpv4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv4", cidrIpv4)
    def getCidrIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getReferencedGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("referencedGroupId", referencedGroupId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ) extends zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly {
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val cidrIpv4: Option[String] =
      scala.Option(impl.cidrIpv4()).map(value => value: String)
    override val cidrIpv6: Option[String] =
      scala.Option(impl.cidrIpv6()).map(value => value: String)
    override val prefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val referencedGroupId: Option[SecurityGroupId] = scala
      .Option(impl.referencedGroupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ): zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly = new Wrapper(impl)
}
