package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RevokeSecurityGroupEgressRequest(
    groupId: SecurityGroupId,
    ipPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] = None,
    securityGroupRuleIds: Option[Iterable[String]] = None,
    cidrIp: Option[String] = None,
    fromPort: Option[Integer] = None,
    ipProtocol: Option[String] = None,
    toPort: Option[Integer] = None,
    sourceSecurityGroupName: Option[String] = None,
    sourceSecurityGroupOwnerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest = {
    import RevokeSecurityGroupEgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest
      .builder()
      .groupId(SecurityGroupId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        securityGroupRuleIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupRuleIds)
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(
        sourceSecurityGroupName.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupName)
      .optionallyWith(
        sourceSecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupOwnerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RevokeSecurityGroupEgressRequest.ReadOnly =
    zio.aws.ec2.model.RevokeSecurityGroupEgressRequest.wrap(buildAwsValue())
}
object RevokeSecurityGroupEgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeSecurityGroupEgressRequest =
      zio.aws.ec2.model.RevokeSecurityGroupEgressRequest(
        groupId,
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupRuleIds.map(value => value),
        cidrIp.map(value => value),
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        toPort.map(value => value),
        sourceSecurityGroupName.map(value => value),
        sourceSecurityGroupOwnerId.map(value => value)
      )
    def groupId: SecurityGroupId
    def ipPermissions: Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def securityGroupRuleIds: Option[List[String]]
    def cidrIp: Option[String]
    def fromPort: Option[Integer]
    def ipProtocol: Option[String]
    def toPort: Option[Integer]
    def sourceSecurityGroupName: Option[String]
    def sourceSecurityGroupOwnerId: Option[String]
    def getGroupId: ZIO[Any, Nothing, SecurityGroupId] = ZIO.succeed(groupId)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getSecurityGroupRuleIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupRuleIds", securityGroupRuleIds)
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getSourceSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceSecurityGroupName", sourceSecurityGroupName)
    def getSourceSecurityGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSecurityGroupOwnerId",
        sourceSecurityGroupOwnerId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest
  ) extends zio.aws.ec2.model.RevokeSecurityGroupEgressRequest.ReadOnly {
    override val groupId: SecurityGroupId =
      zio.aws.ec2.model.primitives.SecurityGroupId(impl.groupId())
    override val ipPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val securityGroupRuleIds: Option[List[String]] = scala
      .Option(impl.securityGroupRuleIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrIp: Option[String] =
      scala.Option(impl.cidrIp()).map(value => value: String)
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val sourceSecurityGroupName: Option[String] =
      scala.Option(impl.sourceSecurityGroupName()).map(value => value: String)
    override val sourceSecurityGroupOwnerId: Option[String] = scala
      .Option(impl.sourceSecurityGroupOwnerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest
  ): zio.aws.ec2.model.RevokeSecurityGroupEgressRequest.ReadOnly = new Wrapper(
    impl
  )
}
