package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionIpamPoolCidrResponse(
    ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse = {
    import ProvisionIpamPoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse
      .builder()
      .optionallyWith(ipamPoolCidr.map(value => value.buildAwsValue()))(
        _.ipamPoolCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.wrap(buildAwsValue())
}
object ProvisionIpamPoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionIpamPoolCidrResponse =
      zio.aws.ec2.model.ProvisionIpamPoolCidrResponse(
        ipamPoolCidr.map(value => value.asEditable)
      )
    def ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr.ReadOnly]
    def getIpamPoolCidr
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
      AwsError.unwrapOptionField("ipamPoolCidr", ipamPoolCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse
  ) extends zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly {
    override val ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
      scala
        .Option(impl.ipamPoolCidr())
        .map(value => zio.aws.ec2.model.IpamPoolCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse
  ): zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly = new Wrapper(
    impl
  )
}
