package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PciId(
    deviceId: Option[String] = None,
    vendorId: Option[String] = None,
    subsystemId: Option[String] = None,
    subsystemVendorId: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.PciId = {
    import PciId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PciId
      .builder()
      .optionallyWith(deviceId.map(value => value: java.lang.String))(
        _.deviceId
      )
      .optionallyWith(vendorId.map(value => value: java.lang.String))(
        _.vendorId
      )
      .optionallyWith(subsystemId.map(value => value: java.lang.String))(
        _.subsystemId
      )
      .optionallyWith(subsystemVendorId.map(value => value: java.lang.String))(
        _.subsystemVendorId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PciId.ReadOnly =
    zio.aws.ec2.model.PciId.wrap(buildAwsValue())
}
object PciId {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PciId] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PciId = zio.aws.ec2.model.PciId(
      deviceId.map(value => value),
      vendorId.map(value => value),
      subsystemId.map(value => value),
      subsystemVendorId.map(value => value)
    )
    def deviceId: Option[String]
    def vendorId: Option[String]
    def subsystemId: Option[String]
    def subsystemVendorId: Option[String]
    def getDeviceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getVendorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendorId", vendorId)
    def getSubsystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subsystemId", subsystemId)
    def getSubsystemVendorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subsystemVendorId", subsystemVendorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PciId
  ) extends zio.aws.ec2.model.PciId.ReadOnly {
    override val deviceId: Option[String] =
      scala.Option(impl.deviceId()).map(value => value: String)
    override val vendorId: Option[String] =
      scala.Option(impl.vendorId()).map(value => value: String)
    override val subsystemId: Option[String] =
      scala.Option(impl.subsystemId()).map(value => value: String)
    override val subsystemVendorId: Option[String] =
      scala.Option(impl.subsystemVendorId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PciId
  ): zio.aws.ec2.model.PciId.ReadOnly = new Wrapper(impl)
}
