package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, CoipPoolId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifySubnetAttributeRequest(
    assignIpv6AddressOnCreation: Option[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = None,
    mapPublicIpOnLaunch: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    subnetId: SubnetId,
    mapCustomerOwnedIpOnLaunch: Option[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = None,
    customerOwnedIpv4Pool: Option[CoipPoolId] = None,
    enableDns64: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    privateDnsHostnameTypeOnLaunch: Option[zio.aws.ec2.model.HostnameType] =
      None,
    enableResourceNameDnsARecordOnLaunch: Option[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = None,
    enableResourceNameDnsAAAARecordOnLaunch: Option[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = None,
    enableLniAtDeviceIndex: Option[Integer] = None,
    disableLniAtDeviceIndex: Option[zio.aws.ec2.model.AttributeBooleanValue] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest = {
    import ModifySubnetAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
      .builder()
      .optionallyWith(
        assignIpv6AddressOnCreation.map(value => value.buildAwsValue())
      )(_.assignIpv6AddressOnCreation)
      .optionallyWith(mapPublicIpOnLaunch.map(value => value.buildAwsValue()))(
        _.mapPublicIpOnLaunch
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        mapCustomerOwnedIpOnLaunch.map(value => value.buildAwsValue())
      )(_.mapCustomerOwnedIpOnLaunch)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CoipPoolId.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(enableDns64.map(value => value.buildAwsValue()))(
        _.enableDns64
      )
      .optionallyWith(
        privateDnsHostnameTypeOnLaunch.map(value => value.unwrap)
      )(_.privateDnsHostnameTypeOnLaunch)
      .optionallyWith(
        enableResourceNameDnsARecordOnLaunch.map(value => value.buildAwsValue())
      )(_.enableResourceNameDnsARecordOnLaunch)
      .optionallyWith(
        enableResourceNameDnsAAAARecordOnLaunch.map(value =>
          value.buildAwsValue()
        )
      )(_.enableResourceNameDnsAAAARecordOnLaunch)
      .optionallyWith(
        enableLniAtDeviceIndex.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.enableLniAtDeviceIndex)
      .optionallyWith(
        disableLniAtDeviceIndex.map(value => value.buildAwsValue())
      )(_.disableLniAtDeviceIndex)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifySubnetAttributeRequest.wrap(buildAwsValue())
}
object ModifySubnetAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySubnetAttributeRequest =
      zio.aws.ec2.model.ModifySubnetAttributeRequest(
        assignIpv6AddressOnCreation.map(value => value.asEditable),
        mapPublicIpOnLaunch.map(value => value.asEditable),
        subnetId,
        mapCustomerOwnedIpOnLaunch.map(value => value.asEditable),
        customerOwnedIpv4Pool.map(value => value),
        enableDns64.map(value => value.asEditable),
        privateDnsHostnameTypeOnLaunch.map(value => value),
        enableResourceNameDnsARecordOnLaunch.map(value => value.asEditable),
        enableResourceNameDnsAAAARecordOnLaunch.map(value => value.asEditable),
        enableLniAtDeviceIndex.map(value => value),
        disableLniAtDeviceIndex.map(value => value.asEditable)
      )
    def assignIpv6AddressOnCreation
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def mapPublicIpOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def subnetId: SubnetId
    def mapCustomerOwnedIpOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def customerOwnedIpv4Pool: Option[CoipPoolId]
    def enableDns64: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def privateDnsHostnameTypeOnLaunch: Option[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecordOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableResourceNameDnsAAAARecordOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableLniAtDeviceIndex: Option[Integer]
    def disableLniAtDeviceIndex
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getAssignIpv6AddressOnCreation
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignIpv6AddressOnCreation",
        assignIpv6AddressOnCreation
      )
    def getMapPublicIpOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("mapPublicIpOnLaunch", mapPublicIpOnLaunch)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getMapCustomerOwnedIpOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "mapCustomerOwnedIpOnLaunch",
        mapCustomerOwnedIpOnLaunch
      )
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getEnableDns64
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDns64", enableDns64)
    def getPrivateDnsHostnameTypeOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] =
      AwsError.unwrapOptionField(
        "privateDnsHostnameTypeOnLaunch",
        privateDnsHostnameTypeOnLaunch
      )
    def getEnableResourceNameDnsARecordOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecordOnLaunch",
        enableResourceNameDnsARecordOnLaunch
      )
    def getEnableResourceNameDnsAAAARecordOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecordOnLaunch",
        enableResourceNameDnsAAAARecordOnLaunch
      )
    def getEnableLniAtDeviceIndex: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("enableLniAtDeviceIndex", enableLniAtDeviceIndex)
    def getDisableLniAtDeviceIndex
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "disableLniAtDeviceIndex",
        disableLniAtDeviceIndex
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ) extends zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly {
    override val assignIpv6AddressOnCreation
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.assignIpv6AddressOnCreation())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val mapPublicIpOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.mapPublicIpOnLaunch())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val mapCustomerOwnedIpOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.mapCustomerOwnedIpOnLaunch())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val customerOwnedIpv4Pool: Option[CoipPoolId] = scala
      .Option(impl.customerOwnedIpv4Pool())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val enableDns64
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableDns64())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val privateDnsHostnameTypeOnLaunch
        : Option[zio.aws.ec2.model.HostnameType] = scala
      .Option(impl.privateDnsHostnameTypeOnLaunch())
      .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecordOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableResourceNameDnsARecordOnLaunch())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableResourceNameDnsAAAARecordOnLaunch
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableResourceNameDnsAAAARecordOnLaunch())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableLniAtDeviceIndex: Option[Integer] = scala
      .Option(impl.enableLniAtDeviceIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val disableLniAtDeviceIndex
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.disableLniAtDeviceIndex())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ): zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly = new Wrapper(impl)
}
